﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Microsoft.VisualBasic;
using System.Data.SqlClient;
using System.Collections.Generic;

namespace rayaneh.commerce
{
    [Serializable]
    public class CartItem
    {
        private string _isbn;
        private string _title;
        private string _picUrl;
        private int _quantity;
        private int _price;
        private int _lineTotal;
        /*      public void New()
              {
              }
              public void New(string isbn, string title, string picUrl, int quantity, int price)
              {
                  _isbn = isbn;
                  _title = title;
                  _picUrl = picUrl;
                  _quantity = quantity;
                  _price = price;
                  _lineTotal = quantity * price;
              } */
        //************
        public string isbn
        {
            get
            {
                return _isbn;
            }
            set
            {
                _isbn = value;
            }
        }
        public string title
        {
            get
            {
                return _title;
            }
            set
            {
                _title = value;
            }
        }
        //****************
        public string picUrl
        {
            get
            {
                return _picUrl;
            }
            set
            {
                _picUrl = value;
            }
        }
        //*************************
        public int quantity
        {
            get
            {
                return _quantity;
            }
            set
            {
                _quantity = value;
            }
        }
        //****************
        public int price
        {
            get
            {
                return _price;
            }
            set
            {
                _price = value;
            }
        }
        //***************
        public int lineTotal
        {
            get
            {
                return _quantity * _price;
            }
        }
    }
    //**********************************
    [Serializable]
    public class shoppingCart
    {
        private DateTime _dateCreated;
        private DateTime _lastUpdate;
        private List<CartItem> _items;
        public shoppingCart()
        {
            if (this._items == null)
            {
                this._items = new List<CartItem>();
                this._dateCreated = System.DateTime.Now;
            }
        }
        public List<CartItem> items
        {
            get
            {
                return _items;
            }
            set
            {
                _items = value;
            }
        }
        public void insert(string isbn, int price, int quantity, string title, string picUrl)
        {
            int itemindex = ItemIndexOfID(isbn);
            if (itemindex == -1)
            {
                CartItem newitem = new CartItem();
                newitem.isbn = isbn;
                newitem.quantity = quantity;
                newitem.price = price;
                newitem.title = title;
                newitem.picUrl = picUrl;
                _items.Add(newitem);
            }
            else
                _items[itemindex].quantity += 1;
            _lastUpdate = DateTime.Now;
        }
        public void update(int RowID, string isbn, int quantity, int price)
        {
            CartItem item = _items[RowID];
            item.isbn = isbn;
            item.quantity = quantity;
            item.price = price;
            _lastUpdate = DateTime.Now;
        }
        public void deleteitem(int RowID)
        {
            _items.RemoveAt(RowID);
            _lastUpdate = DateTime.Now;
        }
        private int ItemIndexOfID(string isbn)
        {
            int index = 0;
            foreach (CartItem item in _items)
            {
                if (item.isbn == isbn)
                    return index;
                index++;
            }
            return -1;
        }

        public int Total
        {
            get
            {
                int t = 0;
                if (_items == null)
                    return 0;
                foreach (CartItem item in _items)
                    t += item.lineTotal;
                return t;
            }
        }
    }

}